grammar relationalAlgebra;

query
    : operator EOF
    ;

operator
    : join
    | antijoin
    | union
    | rec
    | relation
    ;

join
    : 'JOIN' '(' operatorSeq ',' vectorSeq ',' vector ')'
    ;

antijoin
    :  'ANTIJOIN' '(' operatorSeq ',' vectorSeq ',' vector ')'
    ;

union
    : 'UNION' '(' operatorSeq ')'
    ;

rec
    : 'REC' '(' relationName ',' operator ')'
    ;

operatorSeq
    : '[' operator (',' operator)* ']'
    ;

relation
    : relationName
    | '$' IDENTIFIER
    ;

vectorSeq
    : '[' vector (',' vector)* ']'
    ;

vector
    : '[' term (',' term)* ']'
    ;


relationName
    : IDENTIFIER
    ;

term
    : IDENTIFIER
    | functionSym
    ;

functionSym
    : IDENTIFIER '(' term ')'
    ;

IDENTIFIER
    : [a-zA-Z][a-zA-Z0-9_]*
    | [0-9]+
    ;

WS
    : [ \t\r\n]+ -> skip
    ;
